/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.rsf.I_P_ProblemReportAttributes;
import com.ibm.hwmca.p.rsf.I_P_ProblemReportRequestBody;
import com.ibm.hwmca.p.updates.FixpackUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

public class IPapHandler
implements BaseRsfHandlersErrorIds,
BaseRsfDataTransfer,
I_P_ProblemReportAttributes {
    private static String TRACE_MASKF = "XRSFIP F";
    private static String TRACE_MASKT = "XRSFIP T";
    private static String TRACE_MASKD = "XRSFIP D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "IPapHandler");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private static byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static String nullBytes = new String(nulls);
    private static char nullByte = nullBytes.charAt(0);
    static byte fixApplied = I_P_ProblemReportRequestBody.assignByte(128);
    private static File tempPath;
    private String tempFileName = null;
    private File tempFile = null;
    private String remotePath;
    private static final String SEND_INFO = "70";
    private static final String INFO_VRM = "0301";
    private static final String INFO_NOTELOG = "0303";
    private static final String INFO_SERVICE_REQUEST = "0302";
    private static final String INFO_FCDP = "0306";
    private static final String INITIAL_FIX_LIST = "60";
    private static final String FINAL_FIX_LIST = "66";
    private static final String COVER_LETTER = "51";
    private static final String REQUEST_COVER_LETTER_CONFIRM = "74";
    private static final String FIXPACK_IMAGE = "50";
    private static final String REQUEST_FIXPACK_CONFIRM = "75";
    private static final String RESULTS = "72";
    private static final String ERROR = "79";
    private static final String DISCONNECT = "78";
    private static final String CONFIRM_FIX = "76";
    private static final String UPDATED_FIX_LIST = "61";
    private static final String FCDP;
    private static final String VRM_RECORD;
    private static final String ESS_VRM_RECORD;
    private static final String RETAIN_REPLY = "SEND_REPLY";
    private static final String NOTELOG = "82";
    private int response = 99;
    Socket connection;
    private String token = null;
    private static int MAX_MSG_LENGTH;
    private static String[] validTypes;
    private static String[] validVersions;
    private static String userPwd;
    private static String EBCDIC;
    private int papId = 1;
    private static int defaultTimeout;
    private boolean canceled = false;
    private File writeTemp = null;
    private String oldFilename = "";
    private byte[] rawData;
    private static int rawDataStart;
    private long writeSequence;
    private boolean lastRecord = false;
    private final int lastRecNum = -15;
    BufferedInputStream bin;
    BufferedOutputStream bout;
    private I_P_ProblemReportRequestBody rsfRequestBody;
    private ArrayList notelogs;
    private int notelogsProcessed = 0;
    private BaseRsfRequestImpl request;
    private BaseRsfResultDetails resultDetails = new BaseRsfResultDetails();

    public void requestCancelling() {
        this.setCanceled(true);
    }

    public BaseRsfResultDetails getResult() {
        return this.resultDetails;
    }

    public int transmit(TcpConnection tcpPath, RsfRequestBody requestBody, BaseRsfRequestImpl request) throws IOException {
        if (BaseRemoteSupportFacility.testRQ) {
            Trace.trace(TRACE_MASKF, "IPAPHandler.transmit(): about to execute test wait");
            try {
                Thread.sleep(BaseRemoteSupportFacility.testWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "IPAPHandler.transmit(): finished executing test wait");
            if (this.isCanceled()) {
                Trace.trace(TRACE_MASKF, "<- IPAPHandler.transmit(): Canceled during test wait");
                return 99;
            }
        }
        Trace.trace(TRACE_MASKT, "-> IPAPHandler::transmit()");
        if (request.getOwningCredentials() == null) {
            Trace.trace(TRACE_MASKF, "IPAPHandler.transmit: no credentials supplied in request");
        }
        try {
            this.connection = tcpPath.getSocket();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IPAPHandler: unable to get socket from tcp connection");
            this.resultDetails.setReasonCode(4);
            throw e;
        }
        try {
            this.rsfRequestBody = (I_P_ProblemReportRequestBody)requestBody;
        }
        catch (ClassCastException e) {
            this.logInternalError("IPapHandler.transmit(): wrong class type for request. Found " + this.rsfRequestBody.getClass().getName() + ".", e);
            this.resultDetails.setErrLogMsg("Invalid request class type.  Found " + this.rsfRequestBody.getClass().getName());
            Trace.trace(TRACE_MASKT, "<- IPapHandler::transmit()");
            return 999;
        }
        this.request = request;
        this.notelogs = this.rsfRequestBody.getNotelogs();
        try {
            this.bin = new BufferedInputStream(this.connection.getInputStream());
            this.bout = new BufferedOutputStream(this.connection.getOutputStream());
        }
        catch (IOException e) {
            this.resultDetails.setReasonCode(4);
            Trace.trace(TRACE_MASKF, "Exception constructing IO streams " + e.getMessage());
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::transmit ");
            throw e;
        }
        int rc = this.doProcessing();
        Trace.trace(TRACE_MASKT, "<- IPAPHandler::transmit");
        return rc;
    }

    private int doProcessing() throws IOException {
        int loginResult;
        byte[] loginRecord;
        boolean rc = false;
        Trace.trace(TRACE_MASKT, "-> IPAPHandler::doProcessing");
        try {
            if (this.token == null) {
                this.token = RetainUtils.getRetainToken(this.request, this.resultDetails);
            }
            loginRecord = RetainUtils.getLoginInfo(this.papId, this.rsfRequestBody, this.token);
        }
        catch (IOException e) {
            this.logErrorAndContinue("IPAPHandler: error getting token", e, (short)28480);
            throw e;
        }
        catch (Exception e) {
            if (this.token == null) {
                this.logErrorAndContinue("IPAPHandler: error getting token", e, (short)28480);
            } else {
                this.logInternalErrorAndContinue("IPAPHandler error getting login info", e);
            }
            this.resultDetails.setErrLogMsg("Error getting login record for " + this.rsfRequestBody.getClass().getName());
            return 999;
        }
        if (this.isCanceled()) {
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::doTransfer already canceled");
            return 99;
        }
        if (this.token == null && this.request.getOwningCredentials() != null) {
            this.logErrorAndContinue("IPapHandler: Token returned null from getToken", null, (short)28480);
            this.resultDetails.setErrLogMsg("Error: null token returned from getToken()");
            return 999;
        }
        boolean strongAuth = true;
        if (this.token == null) {
            strongAuth = false;
        }
        if ((loginResult = RetainUtils.loginToRetain(this.request, this.connection, this.bin, this.bout, loginRecord, this.resultDetails, strongAuth)) != 0) {
            Trace.trace(TRACE_MASKF, "IPAPHandler.doProcessing(): reporting an unregistered or unrecognized machine");
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IPAPHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::doProcessing()");
            return loginResult;
        }
        boolean OK = true;
        try {
            while (OK && !this.isCanceled()) {
                OK = this.receiveCommand();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            if (this.writeTemp != null) {
                this.writeTemp.delete();
            }
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IPAPHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::doProcessing() OK");
            return this.response;
        }
        catch (IOException i) {
            Trace.trace(TRACE_MASKF, "IPAPHandler::doProcessing() IOException");
            Trace.trace(TRACE_MASKF, i);
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IPAPHandler.doProcessing Error closing connection");
            }
            throw i;
        }
    }

    private boolean receiveCommand() throws IOException {
        Trace.trace(TRACE_MASKD, "-> IPAPHandler::receiveCommand()");
        byte[] datalength = new byte[2];
        int timeout = defaultTimeout;
        if (!this.isCanceled()) {
            byte[] data;
            try {
                data = RetainUtils.receive(this.connection, this.bin, timeout);
                if (data == null || data.length < 2) {
                    this.logErrorAndContinue("IPapHandler.receiveCommand: no data in RETAIN command", null, (short)28530);
                    this.resultDetails.setReasonCode(3);
                    this.response = 0;
                    Trace.trace(TRACE_MASKD, "<- IPAPHandler::receiveCommand() false");
                    return false;
                }
            }
            catch (IOException i) {
                Trace.trace(TRACE_MASKF, "IPAPHandler.receiveCommand: Error receiving PAP request");
                Trace.trace(TRACE_MASKF, i);
                Trace.trace(TRACE_MASKD, "<- IPAPHandler::receiveCommand() throw I/O Exception");
                this.response = 99;
                throw i;
            }
            boolean retval = this.processCommand(data);
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::receiveCommand()" + retval);
            return retval;
        }
        Trace.trace(TRACE_MASKD, "<- IPAPHandler::receiveCommand() false");
        return false;
    }

    private boolean processCommand(byte[] data) throws IOException {
        Trace.trace(TRACE_MASKT, "-> IPAPHandler::processCommand()");
        String command = new String(data, 0, 2, EBCDIC);
        boolean retval = false;
        if (command.equals(SEND_INFO)) {
            String sendInfo;
            if (data.length < 6) {
                this.logRetainError("IPAPHandler: Not enough data on send info, data=" + RsfHexadecimal.buildHexadecimalString(data));
                retval = false;
            }
            if ((sendInfo = new String(data, 2, 4, EBCDIC)).equals(INFO_VRM)) {
                if (this.rsfRequestBody.isStorageRequest() || BaseRemoteSupportFacility.testFlag.equals("ESS")) {
                    this.sendReply(ESS_VRM_RECORD, "Send ESS VRM");
                } else {
                    this.sendReply(VRM_RECORD, "Send VRM");
                }
                retval = true;
            } else if (sendInfo.equals(INFO_SERVICE_REQUEST)) {
                retval = this.sendServiceRequest();
            } else if (sendInfo.equals(INFO_NOTELOG)) {
                retval = this.sendNotelog();
            } else if (sendInfo.equals(INFO_FCDP)) {
                retval = this.sendFcdp();
            } else {
                this.logRetainError("IPAPHandler: Send info parms not understood, data=" + RsfHexadecimal.buildHexadecimalString(data, 0, 6));
                retval = false;
            }
            Trace.trace(TRACE_MASKT, "<- IPAPHandler::processCommand() SEND_INFO " + retval);
            return retval;
        }
        if (command.equals(INITIAL_FIX_LIST)) {
            return this.processInitialFixList(data);
        }
        if (command.equals(FINAL_FIX_LIST)) {
            return this.processFinalFixList(data);
        }
        if (command.equals(COVER_LETTER)) {
            return this.processFixFile(data, 'C');
        }
        if (command.equals(FIXPACK_IMAGE)) {
            return this.processFixFile(data, 'I');
        }
        if (command.equals(REQUEST_COVER_LETTER_CONFIRM)) {
            if (!this.lastRecord) {
                Trace.trace(TRACE_MASKF, "IPapHandler: got request cover letter confirm without last record");
            }
            Trace.trace(TRACE_MASKF, "IPapHandler: sending confirm cover letter: 76+" + RsfHexadecimal.buildHexadecimalString(data, 2, 4));
            this.sendReply(CONFIRM_FIX + new String(data, 2, 2, EBCDIC), "Confirm cover letter");
            this.lastRecord = false;
            return true;
        }
        if (command.equals(REQUEST_FIXPACK_CONFIRM)) {
            if (!this.lastRecord) {
                Trace.trace(TRACE_MASKF, "IPapHandler: got request fixpack confirm without last record");
            }
            Trace.trace(TRACE_MASKF, "IPapHandler: sending confirm fixr: 76+" + RsfHexadecimal.buildHexadecimalString(data, 2, 4));
            this.sendReply(CONFIRM_FIX + new String(data, 2, 2, EBCDIC), "Confirm fixpack");
            this.lastRecord = false;
            return true;
        }
        if (command.equals(RESULTS)) {
            if (data.length < 11) {
                this.logRetainError("IPAPHandler: Not enough data on status, data=" + RsfHexadecimal.buildHexadecimalString(data));
                retval = false;
            }
            this.completeTransaction(data);
            this.resultDetails.setReasonCode(0);
            return false;
        }
        if (command.equals(ERROR)) {
            int printLength = Math.min(data.length, MAX_MSG_LENGTH);
            String rc = "9999";
            String errormsg = "";
            try {
                rc = new String(data, 2, 4, EBCDIC);
                errormsg = new String(data, 0, printLength, EBCDIC);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "IPAPHandler.process ERROR data.length=" + data.length + " message return=" + RsfHexadecimal.buildHexadecimalString(data, 2, printLength));
            Trace.trace(TRACE_MASKF, "            " + errormsg);
            String errMsg = "Error processing in IP PAP=" + rc;
            this.resultDetails.setErrLogMsg("Error record returned from Pap: " + errormsg);
            this.response = 99;
            return false;
        }
        this.logRetainError("Invalid command from RETAIN PAP:" + command);
        Trace.trace(TRACE_MASKT, "<- IPAPHandler::processCommand() invalid command");
        return false;
    }

    private void sendReply(String sendString, String actionName) throws IOException {
        Trace.trace(TRACE_MASKT, "-> IPapHandler::sendReply() '" + sendString + "'");
        RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(sendString.length()), 2, false);
        RetainUtils.send(this.bout, sendString, true);
        Trace.trace(TRACE_MASKD, "<- IPAPHandler." + actionName + " done");
    }

    private boolean sendServiceRequest() throws IOException {
        if (!this.isCanceled()) {
            String data = this.rsfRequestBody.buildData();
            Trace.trace(TRACE_MASKD, "IPap rectype-auto_notify: '" + data.substring(0, 47) + "'");
            Trace.trace(TRACE_MASKD, "IPap contact-phone1: '" + data.substring(47, 102) + "'");
            Trace.trace(TRACE_MASKD, "IPap street: '" + data.substring(203, 239) + "'");
            Trace.trace(TRACE_MASKD, "IPap city: '" + data.substring(311, 347) + "'");
            Trace.trace(TRACE_MASKD, "IPap country-zip: '" + data.substring(347, 395) + "'");
            Trace.trace(TRACE_MASKD, "IPap language: '" + data.substring(395, 399) + "'");
            Trace.trace(TRACE_MASKD, "IPap company: '" + data.substring(399, 435) + "'");
            Trace.trace(TRACE_MASKD, "IPap component id: '" + data.substring(451, 463) + "'");
            Trace.trace(TRACE_MASKD, "IPap component level: '" + data.substring(463, 466) + "'");
            if (data.charAt(569) == 'D') {
                Trace.trace(TRACE_MASKD, "IPap device type: '" + data.substring(570, 574) + "' device model: '" + data.substring(574, 577) + "'" + "' device feature: '" + data.substring(577, 581) + "'" + "' device serial: '" + data.substring(581, 590) + "'");
            }
            try {
                byte[] reqMod = data.substring(615, 616).getBytes(EBCDIC);
                Trace.trace(TRACE_MASKD, "IPap requestModifier=" + RsfHexadecimal.buildHexadecimalString(reqMod));
                byte[] fruOffset = data.substring(891, 893).getBytes(EBCDIC);
                int offset = this.getLength(fruOffset, 0, 2);
                Trace.trace(TRACE_MASKD, "IPap fru offset=" + RsfHexadecimal.buildHexadecimalString(fruOffset) + " in decimal=" + offset);
                byte[] testLength = new byte[]{0, 2, fruOffset[0], fruOffset[1]};
                int decLength = this.getLength(testLength, 0, 4);
                Trace.trace(TRACE_MASKD, "IPap testLength=" + decLength);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKD, "IPap probnum- prob severity: '" + data.substring(616, 634) + "'");
            Trace.trace(TRACE_MASKD, "IPap symptom string (First 70 bytes): '" + data.substring(635, 705) + "'");
            RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(data.length()), 2, false);
            RetainUtils.send(this.bout, data, true);
            Trace.trace(TRACE_MASKD, "IPAPHandler.sendServiceRecord done");
        }
        return true;
    }

    private boolean sendNotelog() throws IOException {
        Trace.trace(TRACE_MASKT, "-> IPapHandler::sendNotelog(): # processed so far=" + this.notelogsProcessed);
        if (this.notelogs == null || this.notelogs.size() <= this.notelogsProcessed) {
            this.logRetainError("IPapHandler: no notelog available when requested by RETAIN");
            return false;
        }
        String notelog = (String)this.notelogs.get(this.notelogsProcessed++);
        notelog = NOTELOG + notelog;
        RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(notelog.length()), 2, false);
        RetainUtils.send(this.bout, notelog, true);
        Trace.trace(TRACE_MASKT, "<-IPapHandler::sendNotelog() #" + this.notelogsProcessed + ".");
        return true;
    }

    private boolean sendFcdp() throws IOException {
        String fcdp = this.rsfRequestBody.getAttribute("FCDP");
        if (fcdp == null) {
            this.logRetainError("IPapHandler: no fcdp available when requested by RETAIN");
            return false;
        }
        fcdp = FCDP + fcdp;
        RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(fcdp.length()), 2, false);
        RetainUtils.send(this.bout, fcdp, true);
        Trace.trace(TRACE_MASKD, "IPAPHandler.sendFcdp done");
        return true;
    }

    private boolean processFinalFixList(byte[] data) {
        try {
            String finalFixList = new String(data, EBCDIC);
            Trace.trace(TRACE_MASKD, "IPapHandler.processFinalFixList =" + finalFixList);
        }
        catch (UnsupportedEncodingException e) {
            this.logInternalError("IPapHandler: EBCDIC encoding not supported", e);
            return false;
        }
        return true;
    }

    private boolean processInitialFixList(byte[] data) throws IOException {
        if (data.length < 8) {
            this.logRetainError("IPapHandler:process initial fix list incorrect length=" + data.length);
        }
        int numItems = this.getLength(data, 2, 2);
        int dataLength = this.getLength(data, 6, 2);
        Trace.trace(TRACE_MASKF, "IPapHandler.processInitialFixList numItems=" + numItems + " dataLength=" + dataLength + "total length (dataLength+8)=" + data.length);
        HashMap fixes = this.rsfRequestBody.getFirmwareLevels();
        int fixIndex = 8;
        for (int i = 0; i < numItems; ++i) {
            fixIndex = 8 + i * 37;
            if (fixIndex + 27 > data.length) {
                Trace.trace(TRACE_MASKF, "IPapHandler: processInitialFixList fixIndex invalid at " + fixIndex);
                break;
            }
            String fixType = new String(data, fixIndex, 1, EBCDIC);
            String ptfNum = new String(data, fixIndex + 3, 7, EBCDIC);
            String description = new String(data, fixIndex + 10, 12, EBCDIC);
            String qualifier = new String(data, fixIndex + 22, 5, EBCDIC);
            Trace.trace(TRACE_MASKF, "IPapHandler: processInitialFixList: fixType='" + fixType + "' ptfNum='" + ptfNum + "' description='" + description + "' qualifier='" + qualifier + "'.");
            description = description.trim();
            qualifier = qualifier.trim();
            String fixpackName = description.substring(1, 8) + "_" + description.substring(8, 11) + "_" + qualifier + ".rpm";
            boolean fixpackExists = FixpackUtilities.isFixpackOnSystem(fixes, fixpackName);
            if (fixpackExists) {
                int fixBits = data[fixIndex + 2];
                data[fixIndex + 2] = I_P_ProblemReportRequestBody.assignByte(fixBits |= fixApplied);
                Trace.trace(TRACE_MASKF, "processInitialFixList: " + fixpackName + " exists on system");
                continue;
            }
            Trace.trace(TRACE_MASKF, "processInitialFixList: " + fixpackName + " doesn't exist on system");
        }
        String reply = UPDATED_FIX_LIST + new String(data, 2, data.length - 2, EBCDIC);
        try {
            Trace.trace(TRACE_MASKD, "IPapHandler.processInitialFixList reply= " + reply);
            RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(reply.length()), 2, false);
            RetainUtils.send(this.bout, reply, true);
        }
        catch (UnsupportedEncodingException e) {
            this.logInternalError("IPapHandler: EBCDIC encoding not supported", e);
            return false;
        }
        return true;
    }

    private void completeTransaction(byte[] data) throws IOException {
        if (data.length != 11) {
            int printLength = Math.min(data.length, MAX_MSG_LENGTH);
            Trace.trace(TRACE_MASKF, "IPAPHandler. data.length=" + data.length + " status return=" + RsfHexadecimal.buildHexadecimalString(data, 2, printLength));
        } else {
            try {
                this.buildReply(new String(data, 2, 4, EBCDIC), new String(data, 6, 5, EBCDIC));
            }
            catch (UnsupportedEncodingException e) {
                this.logInternalError("IPapHandler: EBCDIC encoding not supported", e);
            }
        }
        RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(2), 2, false);
        RetainUtils.send(this.bout, DISCONNECT, true);
        Trace.trace(TRACE_MASKD, "IPAPHandler.completeTransaction done");
    }

    private void buildReply(String status, String pmh) {
        Trace.trace(TRACE_MASKT, "-> IPAPHandler::buildReply()");
        this.response = 0;
        RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
        Trace.trace(TRACE_MASKF, "IPAP Handler return status=" + status);
        if (status.equals("0114")) {
            rsfDetails.putAttribute("Problem status", "0114");
        } else if (status.equals("0117")) {
            rsfDetails.putAttribute("Problem status", "0117");
        } else if (status.equals("0113")) {
            rsfDetails.putAttribute("Problem status", "0113");
        } else {
            rsfDetails.putAttribute("Problem status", status);
        }
        if (pmh != null && !pmh.equals("     ")) {
            rsfDetails.putAttribute("pmh", pmh);
        }
        Trace.trace(TRACE_MASKT, "<- IPAPHandler::buildReply()");
    }

    private boolean processFixFile(byte[] data, char type) throws IOException {
        Trace.trace(TRACE_MASKT, "-> IPapHandler::processFixFile() for " + data.length + " bytes");
        if (data.length < 43) {
            Trace.trace(TRACE_MASKF, "IPAPHandler.processFixFile error data.length=" + data.length + " data=" + RsfHexadecimal.buildHexadecimalString(data));
            this.logRetainError("IPapHandler.processCoverLetter length too short");
            return false;
        }
        Trace.trace(TRACE_MASKD, "IPapHandler.processFixFile header:" + RsfHexadecimal.buildHexadecimalString(data, 0, 43));
        this.rawData = data;
        int fixLength = this.getLength(data, 39, 4);
        this.writeSequence = this.getLength(data, 36, 2);
        byte lr = data[38];
        Trace.trace(TRACE_MASKD, "IPap lr=" + lr + " lastRecNum=" + -15);
        if (lr == -15) {
            this.lastRecord = true;
        }
        Trace.trace(TRACE_MASKD, "IPapHandler.writeFile: sequence=" + this.writeSequence + " lastRecord=" + this.lastRecord + " data length=" + data.length + " fixLength=" + fixLength);
        boolean retval = this.writeFile(this.buildName(data, type));
        Trace.trace(TRACE_MASKD, "IPAPHandler.processFixFile done");
        return retval;
    }

    String buildName(byte[] data, char type) {
        Trace.trace(TRACE_MASKD, "->IPapHandler::buildName()");
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(new String(data, 3, 7, EBCDIC));
            buffer.append("_");
            buffer.append(new String(data, 10, 3, EBCDIC));
            buffer.append("_");
            buffer.append(new String(data, 14, 3, EBCDIC));
        }
        catch (UnsupportedEncodingException e) {
            this.logInternalError("IPapHandler: EBCDIC encoding not supported", e);
            return "";
        }
        if (type == 'C') {
            buffer.append(".xml");
        } else {
            buffer.append(".rpm");
        }
        Trace.trace(TRACE_MASKD, "<- IPapHandler::buildName()");
        return buffer.toString();
    }

    private boolean writeFile(String filename) throws IOException {
        Trace.trace(TRACE_MASKT, "-> IPapHandler::writeFile() " + filename);
        String path = this.rsfRequestBody.getStagingDirectory();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        int dataLength = this.rawData.length - rawDataStart;
        Trace.trace(TRACE_MASKD, "IPapHandler.writeFile: filename= '" + filename + "' at '" + path + "' old filename= '" + this.oldFilename + "'");
        if (this.writeTemp == null || !filename.equals(this.oldFilename)) {
            if (this.writeTemp != null) {
                this.writeTemp.delete();
            }
            Trace.trace(TRACE_MASKD, "IPapHandler.writeFile: about to create new temp file");
            try {
                this.writeTemp = File.createTempFile("iqy", ".tmp", tempPath);
                this.oldFilename = filename;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IPapHandler.writeFile: unable to create temp file");
                new FrameworkLog(logInfo, 28451, e).log(infoLog);
                return false;
            }
        }
        Trace.trace(TRACE_MASKF, "IPapHandler.writeFile: writeFile=" + this.writeTemp);
        RetainUtils.appendToFile(this.writeTemp, this.rawData, rawDataStart, dataLength);
        this.rawData = null;
        if (this.lastRecord) {
            boolean result = RetainUtils.moveNewFile(this.request, this.writeTemp, filename, path);
            this.writeTemp = null;
            if (!result) {
                Trace.trace(TRACE_MASKT, "<-IPapHandler::writeFile() false because error in move");
            }
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFile() true");
        return true;
    }

    private int getLength(byte[] data, int index, int numBytes) throws IllegalArgumentException {
        if (numBytes > 4) {
            throw new IllegalArgumentException("Can't get length for more than four bytes");
        }
        Trace.trace(TRACE_MASKD, "IPapHandler.getLength (hex bytes)=" + RsfHexadecimal.buildHexadecimalString(data, index, numBytes));
        int andByte = 127;
        int length = 0;
        for (int i = 0; i < numBytes; ++i) {
            length *= 256;
            if (data[index + i] < 0) {
                length += (data[index + i] & andByte) + 128;
                continue;
            }
            length += data[index + i];
        }
        return length;
    }

    synchronized void setCanceled(boolean cancel) {
        this.canceled = cancel;
    }

    synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void logRetainError(String errorMsg) {
        this.resultDetails.setReasonCode(3);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = new FrameworkLog(logInfo, 28530);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logErrorAndExit(String errorMsg, Throwable t, short errorId, int resultError) {
        FrameworkLog errLog;
        this.resultDetails.setReasonCode(resultError);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logInternalError(String errorMsg, Throwable t) {
        this.logErrorAndExit(errorMsg, t, (short)28671, 7);
    }

    private void logInternalErrorAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    static {
        FCDP = "85" + nullByte + nullByte;
        VRM_RECORD = "005201" + nullByte + "HMC ";
        ESS_VRM_RECORD = "005201" + nullByte + "ESS ";
        MAX_MSG_LENGTH = 60;
        validTypes = new String[]{"RETAIN"};
        validVersions = new String[]{"0"};
        userPwd = "URSF/PURUS    URSFTST 0924-5575        ";
        EBCDIC = "Cp500";
        defaultTimeout = 300000;
        rawDataStart = 43;
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "IPAPHandler: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
    }
}

